﻿
using System.Threading;
Console.Title = "Fountain of Objects";
Console.ForegroundColor = ConsoleColor.Cyan;

Gamerooms.Gameloop(); 

// Classes I think I will need

public class Gamerooms
{
    public int[,] Gameboard = new int[4, 4];


    public void DrawBoard(Player player, Minotaur minotaur)
    {
        Console.Clear();
        for (int i = 0; i < Gameboard.GetLength(0); i++)
        {
            for (int j = 0; j < Gameboard.GetLength(1); j++)
            {
                if (i == player.PlayerX && j == player.PlayerY)
                {
                    Console.ForegroundColor = ConsoleColor.Green;
                    Console.Write("[X] ");
                }
                else if (i == minotaur.PlayerX && j == minotaur.PlayerY)
                {
                    Console.ForegroundColor = ConsoleColor.Red; // Change color for Minotaur
                    Console.Write("[M] "); // MINOTAUR!!!!!
                }
                else
                    // visual board
                    Console.Write("[ ] "); // add X for current room for player later

                Console.ForegroundColor = Gameboard[i, j] == 0 ? ConsoleColor.White : ConsoleColor.Green;
            }

            Console.WriteLine();
        }
    }

    public static void Gameloop() // game logic 
        // switch for movement? 
    {
        Gamerooms gamerooms = new Gamerooms();
        DateTime start = DateTime.Now;
        Pit pit = new Pit(); 
        pit.PlacePit(3); 
        
        Player player = new Player();
        Minotaur minotaur = new Minotaur { PlayerX = 3, PlayerY = 3 };
        player.PlayerStart(0, 0);
        gamerooms.DrawBoard(player, minotaur);
        Console.ForegroundColor = ConsoleColor.Yellow;
        Console.WriteLine("Light peaks into this room from outside, this is the entrance of the cave!");
        while (true) // Main game loop
        {
            minotaur.MoveRandomly(pit);   
            if (player.PlayerX == minotaur.PlayerX && player.PlayerY == minotaur.PlayerY)
            { 
                gamerooms.DrawBoard(player, minotaur);
                Console.ForegroundColor = ConsoleColor.Red;
                Console.WriteLine("The Minotaur has caught you! Game over.");
                DateTime end = DateTime.Now;
                TimeSpan difference = end - start;
                Console.ForegroundColor = ConsoleColor.Magenta;
                Console.WriteLine($" {difference.TotalSeconds} seconds to make it out");
                break; // Exit the game loop to end the game
            }
            pit.CheckAdjacentRoomsForPits(player, pit);
            player.Move();
            // Check if the player is in a pit room
            if (pit.IsPitRoom(player.PlayerX, player.PlayerY))
            {
                pit.TeleportPlayer(player); // Teleport 
                Thread.Sleep(2000);
                Console.ResetColor();
                gamerooms.DrawBoard(player, minotaur); 
                continue; 
            }
            
            if (player.PlayerX == 0 && player.PlayerY == 0)
            {
                Console.ForegroundColor = ConsoleColor.Yellow;
                Console.WriteLine("Light peaks into this room from outside, this is the entrance of the cave!");
                Thread.Sleep(2000);
                if (WinCondition())
                {
                    DateTime end = DateTime.Now;
                    TimeSpan difference = end - start;
                    Console.ForegroundColor = ConsoleColor.Magenta;
                    Console.WriteLine($" {difference.TotalSeconds} seconds to make it out");
                    break;
                }
            }
            else if (player.PlayerX == 0 && player.PlayerY == 2 && (Fountain.IsFountainOn == false))
            {
                gamerooms.DrawBoard(player, minotaur);
                Console.ForegroundColor = ConsoleColor.Blue;
                Console.WriteLine("You hear eerie dripping sounds.");
                Console.ForegroundColor = ConsoleColor.White;
                Console.WriteLine("Do you want to enable the fountain? Type 'enable' to activate it.");
                string input = Console.ReadLine().ToLower();
                if (input.Equals("enable", StringComparison.OrdinalIgnoreCase))
                {
                    Fountain.IsFountainOn = true;
                    Console.ForegroundColor = ConsoleColor.Cyan;
                    Console.WriteLine("The Fountain of Objects has been reactivated!");
                    Thread.Sleep(3000);
                }

            }
            else if (player.PlayerX == 0 && player.PlayerY == 2 && (Fountain.IsFountainOn == true))
            {
                Console.ForegroundColor = ConsoleColor.Cyan;
                Console.WriteLine("You hear roaring sounds from the fountain.");
                Console.ForegroundColor = ConsoleColor.White;
                Console.WriteLine("Do you want to disable the fountain? Type 'disable' to deactivate it.");
                string input = Console.ReadLine().ToLower();
                if (input.Equals("disable", StringComparison.OrdinalIgnoreCase))
                {
                    if (Fountain.IsFountainOn == true)
                    {
                        Fountain.IsFountainOn = false;
                        Console.ForegroundColor = ConsoleColor.DarkBlue;
                        Console.WriteLine("The rush of water has been revoked!");
                        Thread.Sleep(3000);
                        gamerooms.DrawBoard(player, minotaur);
                    }
                }
            }
            else
            {
                gamerooms.DrawBoard(player, minotaur);

            }
            

        }

        {

        }

    }

    public static bool WinCondition()
    {
        if (Fountain.IsFountainOn == true)
        {
            Console.ForegroundColor = ConsoleColor.Yellow;
            Console.WriteLine("You saved the fountain and made it out safely!");
            return true;
        }
        else return false;

    }

    public class Fountain : Gamerooms
    {
        public static bool IsFountainOn = false;

    }

    public class Player : IPlayerActions
    {
        public int PlayerX;
        public int PlayerY;

        public void PlayerStart(int x, int y) // may be used for pit logic later (pits land u in different rooms) 
        {
            PlayerX = x;
            PlayerY = y;
        }

        public void Move()
        {
            Console.ForegroundColor = ConsoleColor.White;
            Console.WriteLine($"Player position is ({PlayerX}, {PlayerY})");
            Console.WriteLine("Enter your move (North, South, East, West):");
            string playerInput = Console.ReadLine();

            if (Enum.TryParse<Direction>(playerInput, true, out Direction direction))
                switch (direction)
                {
                    case Direction.North:
                        if (PlayerX > 0)
                        {
                            PlayerX--; // Assuming Y decreases when moving north
                        }
                        else
                        {
                            Console.ForegroundColor = ConsoleColor.Red;
                            Console.WriteLine("You hit a wall");
                            Thread.Sleep(2000);
                        }

                        break;
                    case Direction.South:
                        if (PlayerX < 3)
                            PlayerX++; // Assuming Y increases when moving south
                        else
                        {
                            Console.ForegroundColor = ConsoleColor.Red;
                            Console.WriteLine("You hit a wall");
                            Thread.Sleep(2000);
                        }

                        break;

                    case Direction.East:
                        if (PlayerY < 3)
                            PlayerY++; // Move right
                        else
                        {
                            Console.ForegroundColor = ConsoleColor.Red;
                            Console.WriteLine("You hit a wall");
                            Thread.Sleep(2000);
                        }

                        break;
                    case Direction.West:
                        if (PlayerY > 0)
                            PlayerY--; // Move left
                        else
                        {
                            Console.ForegroundColor = ConsoleColor.Red;
                            Console.WriteLine("You hit a wall");
                            Thread.Sleep(2000);
                        }

                        break;
                }
            else
            {
                Console.WriteLine("Invalid direction! Please enter North, South, East, or West.");
            }

        }
        
        
    }
    public class Pit : Gamerooms
    {
        public List<(int, int)> PitRoom = new List<(int, int)>();
        private static readonly Random random = new Random();

        public void PlacePit(int pitCount)
        {
            int maxRows = Gameboard.GetLength(0); 
            int maxCols = Gameboard.GetLength(1);

            while (PitRoom.Count < pitCount)
            {
                int row = random.Next(maxRows); // Random row 
                int col = random.Next(maxCols); // Random column 

                // Check if position is prohibited or already has a pit
                if ((row == 0 && col == 0) || (row == 0 && col == 2) || PitRoom.Contains((row, col)))
                {
                    continue; // Skip this position and try another one
                }

                // Add the new pit location to PitRoom
                PitRoom.Add((row, col));
            }
        }

        public bool IsPitRoom(int row, int col)
        {
            return PitRoom.Contains((row, col));
        }

        // Method to teleport the player if they fall into a pit
        public void TeleportPlayer(Player player)
        {
            Random rand = new Random();
            int newRow, newCol;

            do
            {
                newRow = rand.Next(Gameboard.GetLength(0));
                newCol = rand.Next(Gameboard.GetLength(1));
            } while (IsPitRoom(newRow, newCol) || (newRow, newCol) == (0, 0) || (newRow, newCol) == (0, 2));

            player.PlayerX = newRow;
            player.PlayerY = newCol;
            
            Console.ForegroundColor = ConsoleColor.Red;
            Console.WriteLine("You fell into a pit! You are transported to a different room.");
            Console.WriteLine($" Now at: ({player.PlayerX}, {player.PlayerY})");
            
        }
    }

    //check for pits:
    public void CheckAdjacentRoomsForPits(Player player, Pit pit)
    {
        // curr player coords
        int playerX = player.PlayerX;
        int playerY = player.PlayerY;

        // Define the direction offsets for rooms
        (int directionX, int directionY)[] directions = new (int, int)[]
        {
            (-1, 0),   // North
          //  (-1, 1),   // North-East
            (0, 1),    // East
            //(1, 1),    // South-East
            (1, 0),    // South
           // (1, -1),   // South-West
            (0, -1),   // West
          //  (-1, -1)   // North-West
        };

        bool pitNearby = false;

        // Check each direction
        foreach (var (directionX, directionY) in directions)
        {
            int adjacentX = playerX + directionX;
            int adjacentY = playerY + directionY;

            // adjacent coords are within bounds
            if (adjacentX >= 0 && adjacentX < Gameboard.GetLength(0) &&
                adjacentY >= 0 && adjacentY < Gameboard.GetLength(1))
            {
                // Check if there is a pit in the adjacent room
                if (pit.IsPitRoom(adjacentX, adjacentY))
                {
                    pitNearby = true;
                    break; 
                }
            }
        }

        // Display msg 
        if (pitNearby)
        {
            Console.ForegroundColor = ConsoleColor.Yellow;
            Console.WriteLine("You feel a draft. There is a pit in a nearby room.");
            Console.ForegroundColor = ConsoleColor.White; // Reset color
        }
    }

    public interface IPlayerActions
    {
        public void Move(Direction direction)
        {

        }
    }


    public class Minotaur : Player 
    
    {
        private static readonly Random rand = new Random(); // Single Random instance

        public Minotaur() // for minotaur spawn point
        {
            PlayerX = 3;
            PlayerY = 3;
        }

        public void MoveRandomly(Pit pit) // Method for random movement
        {
            int directionIndex = rand.Next(0, 4); // Random direction (0 to 3)

            switch (directionIndex)
            {
                case 0: // North
                    if (PlayerX > 0) PlayerX--;
                    break;
                case 1: // South
                    if (PlayerX < 3) PlayerX++;
                    break;
                case 2: // East
                    if (PlayerY < 3) PlayerY++;
                    break;
                case 3: // West
                    if (PlayerY > 0) PlayerY--;
                    break;
            }
            Console.WriteLine($"Minotaur position is: ({PlayerX}, {PlayerY})");

            // Check if Minotaur falls into a pit
            if (pit.IsPitRoom(PlayerX, PlayerY))
            {
                pit.TeleportPlayer(this); // Teleport if pit
                Console.WriteLine($"Teleported to ({ PlayerX}, {PlayerY}).");
            }
        }
    }


    public enum Direction
    {
        East,
        West,
        North,
        South
    }
}

